﻿Option Strict On
Option Explicit On
Option Infer Off

Imports System.IO
Imports System.ComponentModel

Public Class FileListBox
#Region "Pola prywatne"
    'wewnętrzne
    Private listaKatalogow As String() = Nothing
    Private listaPlikow As String() = Nothing
    Private listaDyskow As String() = Nothing
    Private pokazujDwieKropki As Boolean = True
    'konfigurowanie komponentu
    Private sciezkaKatalogu As String = Nothing
    Private uwzglednijKatalogi As Boolean = True
    Private uwzglednijPliki As Boolean = True
    Private uwzglednijDyski As Boolean = True
    Private uwzglednijKatalogNadrzedny As Boolean = True
    Private mFiltr As String = Nothing

    'Private mozliweZmienianieKatalogow As Boolean = True
    <Category("Katalog"), Description("Własność MozliweZmienianieKatalogow określa, czy kontrolka umożliwia zmianę wyświetlanego katalogu przez wskazanie i podwójne kliknięcie katalogu lub dysku widocznego na liście.")>
    Public Property MozliweZmienianieKatalogow As Boolean = True
#End Region

#Region "Metody prywatne"
    Private Sub PobierzZawartoscKatalogu()
        If sciezkaKatalogu Is Nothing Then sciezkaKatalogu = Directory.GetCurrentDirectory()

        pokazujDwieKropki = sciezkaKatalogu <> Path.GetPathRoot(sciezkaKatalogu) And uwzglednijKatalogNadrzedny

        If Not Directory.Exists(sciezkaKatalogu) Then
            Throw New DirectoryNotFoundException("Katalog " & sciezkaKatalogu & " nie istnieje!")
        End If
        ListBox1.Items.Clear()

        If uwzglednijKatalogi Then
            If pokazujDwieKropki Then ListBox1.Items.Add("[..]")
            listaKatalogow = Directory.GetDirectories(sciezkaKatalogu)
            Array.Sort(listaKatalogow)
            'ListBox1.Items.AddRange(listaKatalogow)
            For Each katalog As String In listaKatalogow
                ListBox1.Items.Add("[" & Path.GetFileName(katalog) & "]")
            Next
        End If
        If uwzglednijPliki Then
            'listaPlikow = Directory.GetFiles(sciezkaKatalogu)
            If mFiltr IsNot Nothing Then
                listaPlikow = Directory.GetFiles(sciezkaKatalogu, mFiltr)
            Else
                listaPlikow = Directory.GetFiles(sciezkaKatalogu)
            End If
            Array.Sort(listaPlikow)
            'ListBox1.Items.AddRange(listaPlikow)
            For Each plik As String In listaPlikow
                ListBox1.Items.Add(Path.GetFileName(plik))
            Next
        End If
        If uwzglednijDyski Then
            listaDyskow = Directory.GetLogicalDrives()
            'ListBox1.Items.AddRange(listaDyskow)
            For Each dysk As String In listaDyskow
                ListBox1.Items.Add("<" & dysk.Substring(0, 2) & ">")
            Next
        End If
    End Sub
#End Region

    Public Sub New()
        InitializeComponent()

        'sciezkaKatalogu = System.Environment.GetFolderPath(System.Environment.SpecialFolder.MyPictures)
        'filtr = "*.jpg"
        'uwzglednijDyski = False

        PobierzZawartoscKatalogu()
    End Sub

    Private Sub ListBox1_DoubleClick(sender As System.Object, e As System.EventArgs) Handles ListBox1.DoubleClick
        If Not mozliweZmienianieKatalogow Then Return

        Dim przesuniecie As Integer = If(pokazujDwieKropki And uwzglednijKatalogi, 1, 0)
        Dim numer As Integer = ListBox1.SelectedIndex - przesuniecie '+1 dla [..]
        Dim poczatekPlikow As Integer = If(uwzglednijKatalogi, listaKatalogow.Length, 0)
        Dim poczatekDyskow As Integer = poczatekPlikow + If(uwzglednijPliki, listaPlikow.Length, 0)

        'zmiana katalogu
        Dim nowaSciezkaKatalogu As String = Nothing
        If numer = -1 Then nowaSciezkaKatalogu = sciezkaKatalogu & "\.."
        If numer >= 0 And numer < poczatekPlikow Then nowaSciezkaKatalogu = listaKatalogow(numer)
        If numer >= poczatekDyskow Then nowaSciezkaKatalogu = listaDyskow(numer - poczatekDyskow)
        If nowaSciezkaKatalogu IsNot Nothing And Directory.Exists(nowaSciezkaKatalogu) Then
            sciezkaKatalogu = Path.GetFullPath(nowaSciezkaKatalogu)
            PobierzZawartoscKatalogu()
            OnZmianaKatalogu(Me, e)
        End If

        'dwukrotne kliknięcie pliku
        Dim sciezkaPliku As String = Nothing
        If numer >= poczatekPlikow And numer < poczatekDyskow Then sciezkaPliku = listaPlikow(numer - poczatekPlikow)
        If sciezkaPliku IsNot Nothing And File.Exists(sciezkaPliku) Then Me.OnDwukrotneKliknieciePliku(Me, e, Path.GetFullPath(sciezkaPliku))
    End Sub

#Region "Właściwości"
    <Category("Katalog"), Description("Własność ŚcieżkaKatalogu wskazuje na katalog prezentowany w kontrolce.")>
    Public Property ŚcieżkaKatalogu As String
        Set(value As String)
            Me.sciezkaKatalogu = value
            PobierzZawartoscKatalogu()
            OnZmianaKatalogu(Me, New EventArgs())
        End Set
        Get
            Return Me.sciezkaKatalogu
        End Get
    End Property

    <Category("Katalog"), Description("Własność Filtr definiuje maskę prezentowanych w kontrolce plików.")>
    Public Property Filtr As String
        Set(value As String)
            Me.mFiltr = value
            PobierzZawartoscKatalogu()
        End Set
        Get
            Return Me.mFiltr
        End Get
    End Property

    <Category("Katalog"), Description("Własność CzyKatalogiWidoczne określa czy w kontrolce widoczne są katalogi.")>
    Public Property CzyKatalogiWidoczne As Boolean
        Set(value As Boolean)
            Me.uwzglednijKatalogi = value
            PobierzZawartoscKatalogu()
        End Set
        Get
            Return Me.uwzglednijKatalogi
        End Get
    End Property

    <Category("Katalog"), Description("Własność CzyPlikiWidoczne określa czy w kontrolce widoczne są pliki.")>
    Public Property CzyPlikiWidoczne As Boolean
        Set(value As Boolean)
            Me.uwzglednijPliki = value
            PobierzZawartoscKatalogu()
        End Set
        Get
            Return Me.uwzglednijPliki
        End Get
    End Property

    <Category("Katalog"), Description("Własność CzyDyskiWidoczne określa czy w kontrolce widoczne są dyski.")>
    Public Property CzyDyskiWidoczne As Boolean
        Set(value As Boolean)
            Me.uwzglednijDyski = value
            PobierzZawartoscKatalogu()
        End Set
        Get
            Return Me.uwzglednijDyski
        End Get
    End Property

    <Category("Katalog"), Description("Własność CzyKatalogNadrzędnyWidoczny określa czy w kontrolce widoczny jest symbol katalogu nadrzędnego.")>
    Public Property CzyKatalogNadrzędnyWidoczny As Boolean
        Set(value As Boolean)
            Me.uwzglednijKatalogNadrzedny = value
            PobierzZawartoscKatalogu()
        End Set
        Get
            Return Me.uwzglednijKatalogNadrzedny
        End Get
    End Property

    <Category("Katalog"), Description("Ścieżka zaznaczonego katalogu lub pliku.")>
    Public ReadOnly Property ŚcieżkaDoZaznaczonegoElementu As String
        Get
            Dim przesuniecie As Integer = If(pokazujDwieKropki And uwzglednijKatalogi, 1, 0)
            Dim numer As Integer = ListBox1.SelectedIndex - przesuniecie '+1 dla [..]
            Dim poczatekPlikow As Integer = If(uwzglednijKatalogi, listaKatalogow.Length, 0)
            Dim poczatekDyskow As Integer = poczatekPlikow + If(uwzglednijPliki, listaPlikow.Length, 0)

            Dim pelnaSciezka As String = Nothing
            If numer = -1 And przesuniecie = 1 Then pelnaSciezka = sciezkaKatalogu & "\.."
            If numer >= 0 And numer < poczatekPlikow Then pelnaSciezka = listaKatalogow(numer)
            If numer >= poczatekPlikow And numer < poczatekDyskow Then pelnaSciezka = listaPlikow(numer - poczatekPlikow)
            If numer >= poczatekDyskow Then pelnaSciezka = listaDyskow(numer - poczatekDyskow)

            If pelnaSciezka Is Nothing Then Return ""

            Return Path.GetFullPath(pelnaSciezka)
        End Get
    End Property

#End Region

#Region "Zdarzenia"
    Private Sub ListBox1_SelectedIndexChanged(sender As System.Object, e As System.EventArgs) Handles ListBox1.SelectedIndexChanged
        Me.OnClick(e)
        Me.OnZmianaZaznaczonegoElementu(sender, e)
    End Sub

    Private Sub ListBox1_MouseDown(sender As System.Object, e As System.Windows.Forms.MouseEventArgs) Handles ListBox1.MouseDown
        Me.OnMouseDown(e)
    End Sub

    Public Delegate Sub ZmianaZaznaczonegoElementuEventHandler(ByVal sender As Object, ByVal e As EventArgs)

    <Category("Katalog"), Description("Następuje po zmianie zaznaczonego elementu.")>
    Public Event ZmianaZaznaczonegoElementu As ZmianaZaznaczonegoElementuEventHandler

    Protected Overridable Sub OnZmianaZaznaczonegoElementu(ByVal sender As Object, ByVal e As EventArgs)
        RaiseEvent ZmianaZaznaczonegoElementu(Me, e)
    End Sub

    <Category("Katalog"), Description("Występuje przy zmianie prezentowanego katalogu.")>
    Public Event ZmianaKatalogu As EventHandler

    Protected Overridable Sub OnZmianaKatalogu(ByVal sender As Object, ByVal e As EventArgs)
        RaiseEvent ZmianaKatalogu(sender, e)
    End Sub

    Public Delegate Sub DwukrotneKliknieciePlikuEventHandler(ByVal sender As Object, ByVal e As EventArgs, ByVal nazwaPliku As String)

    <Category("Katalog"), Description("Występuje w przypadku dwukrotnego kliknięcia jednego z plików widocznych na liście.")>
    Public Event DwukrotneKliknieciePliku As DwukrotneKliknieciePlikuEventHandler

    Protected Overridable Sub OnDwukrotneKliknieciePliku(ByVal sender As Object, ByVal e As EventArgs, ByVal nazwaPliku As String)
        RaiseEvent DwukrotneKliknieciePliku(Me, e, nazwaPliku)
    End Sub

#End Region

    Public Overrides Sub Refresh()
        MyBase.Refresh()
        PobierzZawartoscKatalogu()
    End Sub

End Class
